/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: HexEdit.h 12626 2018-10-30 14:55:29Z LuisContreras $:

  Description:
    Edit Control supporting hexadecimal entries

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-04-29  Updated to latest cifXUser / stdint.h
    2010-2-22   VS2005 Compiler Warnings fixed
    2006-07-04  initial version

**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file HexEdit.h
///   Edit Control supporting hexadecimal entries
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include <stdint.h>

///////////////////////////////////////////////////////////////////////////////////////////
/// Edit Control supporting hexadecimal entries
///////////////////////////////////////////////////////////////////////////////////////////
class CHexEdit : public CEdit
{
	DECLARE_DYNAMIC(CHexEdit)

public:
	CHexEdit();
	virtual ~CHexEdit();

protected:
	DECLARE_MESSAGE_MAP()

  bool                        m_fDisplayHex;          //!< true if value is displayed in hexadecimal notation
  unsigned long               m_ulHexWidth;           //!< Width of the hexadecimal notation

  bool                        m_fForceHexConversion;  //!< Force inputs to be handled as hexadecimal
  unsigned long               m_ulValue;              //!< Current value of the control
  __unaligned uint32_t*       m_pulValue;             //!< Pointer to a variable receiving updated values

public:
  afx_msg void OnEnChange();
  void         Update(void);

  bool GetViewStyle(void)
  {
    return m_fDisplayHex;
  }

  void  SetViewStyle(bool fHex = true)
  {
    m_fDisplayHex = fHex;
    Update();
  }

  unsigned long GetHexWidth(void)
  {
    return m_ulHexWidth;
  }

  void SetHexWidth(unsigned long ulNewWidth)
  {
    m_ulHexWidth = ulNewWidth;
    Update();
  }

  unsigned long GetValue(void)
  {
    return m_ulValue;
  }

  void SetValue(unsigned long ulNewValue)
  {
    m_ulValue = ulNewValue;
    if(m_pulValue != NULL)
      *m_pulValue = ulNewValue;
    Update();
  }

  void SetUpdateVariable(__unaligned uint32_t* pulVarToSet)
  {
    m_pulValue = pulVarToSet;
    SetValue(m_ulValue);
  }

  afx_msg void OnEnKillfocus();
};


